function test_suite = testDiag %#ok<STOUT>
initTestSuite;

function testScalar %#ok<*DEFNU>
expected = polysym('0');
actual = diag(expected);
assertEqual(expected,actual)

function testDiagDiag
expected = polysym('x',[3 1]);
actual = diag(diag(expected));
assertEqual(expected,actual)

function testVectorDefault
p = polysym('x',[3 1]);
actual = diag(p);
expected = polysym({'x1','0','0'; '0','x2','0';'0','0','x3'});
assertEqual(expected,actual)

function testVectorZeroK
p = polysym('x',[3 1]);
actual = diag(p,0);
expected = polysym({'x1','0','0'; '0','x2','0';'0','0','x3'});
assertEqual(expected,actual)

function testVectorPositiveK
p = polysym('x',[2 1]);
actual = diag(p,1);
expected = polysym({'0','x1','0'; '0','0','x2';'0','0','0'});
assertEqual(expected,actual)

function testVectorNegativeK
p = polysym('x',[2 1]);
actual = diag(p,-1);
expected = polysym({'0','0','0'; 'x1','0','0';'0','x2','0'});
assertEqual(expected,actual)
